ALTER FUNCTION [dbo].[UFD_EST_PED_VD_DESOVA_RET_EXCESSO] (@CD_FILIAL INT, @ZERAR_ESTOQUE INT =0)	

RETURNS @RS_RETORNO  TABLE (CD_PROD			INT, 
								QT_EST			MONEY,
								QT_EXCESSO		MONEY) 

AS
BEGIN


DECLARE @RS_PROD TABLE (CD_PROD			INT,  
						QT_EST			MONEY,
						QT_EMAX			MONEY,
						QT_FACEAMENTO	MONEY,
						QT_LIMITADOR	MONEY,
						QT_FINANCIADO	MONEY ) 
						
INSERT INTO @RS_PROD			
SELECT
	C.CD_PROD, 
	C.QT_EST, 
	 ROUND( (C.MEDIAF/30.00  * (CASE WHEN ISNULL(EMAX,0) = 0 THEN
							CASE WHEN ISNULL(F.PARAM_EST ,0) = 0  THEN
								 ISNULL(G.PARAM_EST ,0)
							 ELSE
								 F.PARAM_EST
							 END
							ELSE EMAX END )), 0 ) EMAX_QTDE  ,
	C.QTDE_FACEAMENTO,
	C.QTDE_LIMITADOR,
	C.QTDE_FINANCIADO 
	  
FROM
	EST_PROD_CPL C
	INNER JOIN EST_PROD P ON 
	C.CD_EMP  = P.CD_EMP AND
	C.CD_PROD = P.CD_PROD
	
	INNER JOIN EST_PROD_FABRIC F  ON 
	P.CD_FABRIC = F.CD_FABRIC 
	
	LEFT JOIN ( SELECT 
					CD_FABRIC,
					G.PARAM_EST 
				FROM 
					EST_PROD_FABRIC_GRUPO G
					INNER JOIN EST_PROD_FABRIC_GRUPO_EST_PROD_FABRIC F ON 
					G.CD_CTR_GRUPO = F.CD_CTR_GRUPO
				WHERE
					G.CD_CTR_GRUPO =1 ) G ON 
	P.CD_FABRIC = G.CD_FABRIC 		 
	 
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON 
	C.CD_EMP  = A.CD_EMP AND
	C.CD_PROD = A.CD_PROD
WHERE
	C.CD_EMP=1
	AND C.CD_FILIAL =@CD_FILIAL
	AND C.QT_EST > 0;

	INSERT INTO @RS_RETORNO
	SELECT  
		CD_PROD	 , 
		QT_EST ,		
		QT_EST - (CASE WHEN QT_LIMITADOR > 0 THEN 
			QT_LIMITADOR
		 WHEN  QT_EMAX >  QT_FACEAMENTO AND  QT_EMAX > QT_FINANCIADO THEN 
			QT_EMAX 
		WHEN   QT_FACEAMENTO > QT_EMAX AND  QT_FACEAMENTO > QT_FINANCIADO THEN 
			QT_FACEAMENTO
		WHEN  QT_FINANCIADO >  QT_FACEAMENTO AND QT_FINANCIADO >  QT_EMAX   THEN 
			QT_FINANCIADO
		ELSE 	 QT_EMAX  END) EXCESSO   
	FROM 
		@RS_PROD
	WHERE
		QT_EST - ( case WHEN @ZERAR_ESTOQUE = 1  THEN 0
					ELSE
						CASE WHEN QT_LIMITADOR > 0 THEN 
							QT_LIMITADOR
						 WHEN  QT_EMAX >  QT_FACEAMENTO AND  QT_EMAX > QT_FINANCIADO THEN 
							QT_EMAX 
						WHEN   QT_FACEAMENTO > QT_EMAX AND  QT_FACEAMENTO > QT_FINANCIADO THEN 
							QT_FACEAMENTO
						WHEN  QT_FINANCIADO >  QT_FACEAMENTO AND QT_FINANCIADO >  QT_EMAX   THEN 
							QT_FINANCIADO
						ELSE 	 QT_EMAX  END
					END
					
					) > 0 ;
		RETURN;			
END

GO


